********************************************************************************
*** Political alternatives under European economic governance:  
*** Evidence from German budget speeches (2009-2019)			
*** Author: Johannes Karremans
*** Forthcoming publication in: Journal of European Public Policy
*** Date: 19.03.2020
*** Project: "A comparative study of budgetary discourse in the Eurozone"
*** Funded by: Austria Science Fund, Grant nr M_2591, Lise Meitner Programme 
********************************************************************************
clear all
set more off
set maxvar 12000
set mem 800m
set matsize 800

use "$workingfolder/Karremans_Budgetspeeches_DE.dta", clear

*******************************************************************
*** Main results (Figures 2-3, and Online Appendix) ***************
*******************************************************************
tab j_cat budget_year, col nofreq
tab p_type j_cat
tab p_type byear3, col nofreq

/*  N.B. In the published version of the paper, for visualisation purposes
    some of the justification categories were combined in the following way:
	"Environmental" added to "Social"; "Demography" added to "Financial"; 
	"Security" and "State polity" added to "Other". ****/

	
*******************************************************************
*** Table 1 *******************************************************
*******************************************************************
*** creating a variable 'social'
gen jsocial = (j_cat==1  |  j_cat==5) // 1=Social, 5=Environmental
gen jsocial2 = (j_cat==1) // 1=Social

*browse lagyear budget_year jsocial byear3 surplus
sum surplus if byear3!=1
egen zsurplus2=std(surplus) if byear3!=1

*** Social justifications (incl. environmental) ***
*M1
reg jsocial i.byear3 if byear3!=1, cluster(budget_year)
*M2
reg jsocial i.byear3 zsurplus2 if byear3!=1, cluster(budget_year)
*** Social justifications (excl. environmental) ***
*M1
reg jsocial2 i.byear3 if byear3!=1, cluster(budget_year)
*M2
reg jsocial2 i.byear3 zsurplus2 if byear3!=1, cluster(budget_year)
*******************************************************************
